% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdd.R
\name{pdd}
\alias{pdd}
\title{calculate posterior probabilities of a gene to be differential distributed}
\usage{
pdd(
  data,
  cd,
  bp,
  D,
  random = TRUE,
  norm = TRUE,
  epi = 1,
  Upper = 1000,
  nrandom = 50,
  iter = 20,
  reltol = 0.001,
  stp1 = 1e-06,
  stp2 = 0.01,
  K = 0
)
}
\arguments{
\item{data}{normalized preprocessed transcripts}

\item{cd}{conditions label}

\item{bp}{bioc parallel parameter}

\item{D}{distance matrix of cells or cluster of cells or a given clustering}

\item{random}{boolean indicator of whether randomzation has been been implemented on distance matrix}

\item{norm}{boolean indicator of whether the input expression data is normalized}

\item{epi}{tol for change of validity score in determining number of clusters}

\item{Upper}{bound for hyper parameters optimization}

\item{nrandom}{number of random generated distance matrix}

\item{iter}{max number of iterations for EM}

\item{reltol}{relative tolerance for optim on weighting paramters}

\item{stp1}{step size of hyperparameter alpha (shared by all units) in one step EM}

\item{stp2}{step size of hyperparameter beta (unit specific) in one step EM}

\item{K}{number of subtypes, could be user specified or determined internally(set to 0)}
}
\value{
posterior probabilities of a gene to be differential distributed
}
\description{
calculate posterior probabilities of a gene to be differential distributed
}
\examples{
data(sim_dat)
dat <- extractInfo(sim_dat)
data_counts <- dat$count_matrix
cd <- dat$condition
bp <- BiocParallel::MulticoreParam(4)
D_c <- calD(data_counts,bp)
pDD <- pdd(data_counts,cd,bp,D_c)
}
