% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{save_new_model}
\alias{save_new_model}
\title{Save a model to the package}
\usage{
save_new_model(new_model, include.default = TRUE, path_to_models = tempdir())
}
\arguments{
\item{new_model}{new model to be added into the classification tree}

\item{include.default}{whether include the default models of the package 
in the list of new trained models or not. 
If users further want to classify cells, they can only use default 
pretrained model list or their new model list. 
Including default models in new trained models helps users using 
both of them once. In addition, default pretrained models
of the package cannot be changed or removed. 
This can be done with the new trained model list.}

\item{path_to_models}{path to the folder containing the list of new models.}
}
\value{
no return value, but the model is now saved to database
}
\description{
Save a model to the package
}
\examples{
# load small example dataset
data("tirosh_mel80_example")

# train classifier
selected_marker_genes_T = c("CD4", "CD8A", "CD8B")
set.seed(123)
classifier_t <- train_classifier(train_obj = tirosh_mel80_example,
assay = 'RNA', layer = 'counts', marker_genes = selected_marker_genes_T, 
cell_type = "t cells", tag_slot = 'active.ident')

# save the trained classifier to system 
# test classifier can be used before this step
# Note: We do not include the default models here to runtime of the example
save_new_model(new_model = classifier_t, path_to_models = tempdir(), 
               include.default = FALSE)

# verify if new model has been saved
print(names(load(file.path(tempdir(), "new_models.rda"))))
delete_model("t cells")

}
