#' @name saseRExample
#' @description saseR example data, obtained from the ASpli package
#' (https://bioconductor.org/packages/release/bioc/html/ASpli.html,
#' 10.1093/bioinformatics/btab141).
#' @title saseRExample
#' @return Loads all data needed to run examples
#' @usage data(saseRExample)
NULL


#' @name ASpliSE
#' @title ASpliSE
#' @description SummarizedExperiment containing gene counts, bin counts and
#' junction counts in the metadata slots, together with some rowData
#' information. Output from BamtoAspliCounts.
#' @return Loads all data needed to run vignette and examples
#' @usage data(saseRExample)
NULL


#' @name features
#' @title features
#' @description features used to count bam-files. These are obtained by
#' binGenome from ASpli.
#' @format /
#' @source https://doi.org/10.1093/bioinformatics/btab141
#' @references Estefania Mancini, Andres Rabinovich, Javier Iserte, Marcelo
#' Yanovsky, Ariel Chernomoretz, ASpli: integrative analysis of splicing
#' landscapes through RNA-Seq assays, Bioinformatics, Volume 37, Issue 17,
#' September 2021, Pages 2609–2616,
#' https://doi.org/10.1093/bioinformatics/btab141
#' @return Loads all data needed to run vignette and examples
#' @usage data(saseRExample)
NULL

#' @name SEgenes
#' @title SEgenes
#' @description SummarizedExperiment containing gene-level counts to perform
#' an example aberrant expression analysis.
#' @return Loads all data needed to run vignette and examples
#' @usage data(saseRExample)
NULL

#' @name SEbins
#' @title SEbins
#' @description SummarizedExperiment containing bin-level counts to perform
#' an example aberrant splicing analysis.
#' @return Loads all data needed to run vignette and examples
#' @usage data(saseRExample)
NULL

#' @name SEjunctions
#' @title SEjunctions
#' @description SummarizedExperiment containing junction-level counts to
#' perform an example aberrant splicing analysis
#' @return Loads all data needed to run vignette and examples
#' @usage data(saseRExample)
NULL




