% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{pruneIntervals}
\alias{pruneIntervals}
\title{Prune nested k-mer intervals from called k-mer peak set.}
\usage{
pruneIntervals(intervals, start = "s", end = NULL)
}
\arguments{
\item{intervals}{data.frame containing called k-mer peaks
information (format as output from kmerPeaks function).}

\item{start}{name of column in intervals data.frame containing
interval start coordinates}

\item{end}{name of column in interval data.frame containing
interval end coordinates; if no such column present, default
NULL value indicates that end coordinates should be obtained by
adding nchar(intervals$kmer) to the start coordinates to obtain
end coordinates.}
}
\value{
modified data.frame containing called k-mer peaks
    information (format as output from kmerPeaks function).
}
\description{
Every k-mer identified by SArKS is derived as a substring defined
by the interval running position i to position i+k-1 of the
concatenation of all input sequences. In some cases a j-mer (with j
< k) may be separately identified as a peak by SArKS for which the
j-mer interval is entirely contained within [i, i+k-1]; this
function removes such nested intervals from the reported collection
of peaks.
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)
filters <- sarksFilters(halfWindow=4, spatialLength=0, minGini=1.1)
permDist <- permutationDistribution(sarks, 250, filters, seed=123)
thresholds <- permutationThresholds(filters, permDist, nSigma=2.0)
peaks <- kmerPeaks(sarks, filters, thresholds)
prunedPeaks <- pruneIntervals(peaks)
}
\references{
Wylie, D.C., Hofmann, H.A., and Zemelman, B.V. (2019)
    SArKS: de novo discovery of gene expression regulatory motif
    sites and domains by suffix array kernel smoothing,
    Bioinformatics, Vol. 35(20), 3944-3952

    \url{https://academic.oup.com/bioinformatics/article-abstract/35/20/3944/5418797}
}
