% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{kmerCounts}
\alias{kmerCounts}
\title{Count occurrences of k-mer}
\usage{
kmerCounts(kmer, seqs, directional = TRUE, overlap = FALSE)
}
\arguments{
\item{kmer}{character vector or XStringSet of k-mers to search for.}

\item{seqs}{character vector or XStringSet of sequences in which to
search for and count occurrences of kmer.}

\item{directional}{logical value: if FALSE, counts occurrences of
either kmer or its reverse-complement. Makes sense only if
applying to DNA sequences!}

\item{overlap}{logical value: should overlapping occurrences of
kmer be counted as multiple hits?}
}
\value{
if length(kmer) is one, returns integer vector of counts;
    if length(kmer) is more than one, returns matrix of counts:
    one row per sequence in seqs, one column per expression in
    regex
}
\description{
Counts how often a k-mer (or vector of k-mers) occurs in each
element of a character vector.
}
\examples{
data(simulatedSeqs)
motifCounts <- kmerCounts('CATACTGAGA', simulatedSeqs)
otherCounts <- kmerCounts(
    c('AAAAA', 'CG'),
    simulatedSeqs,
    directional = FALSE
)

}
