% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{blockInfo}
\alias{blockInfo}
\title{Get sarks smoothed scores for input sequence}
\usage{
blockInfo(sarks, block, filters, thresholds, kMax = 12L)
}
\arguments{
\item{sarks}{Sarks object from which information will be derived.}

\item{block}{character vector of names of sequence(s) for which
results are desired}

\item{filters}{output from sarksFilters function indicating what
combinations of filter parameters halfWindow, spatialLength,
and minGini were used.}

\item{thresholds}{output from permutationThresholds specifying
thresholds used for k-mer peak calling.}

\item{kMax}{integer value indicating the maximum k-mer length to be
reported.}
}
\value{
data.frame in same format as result of kmerPeaks giving
    detailed information about every spatial position within
    specified sequences/blocks.
}
\description{
Returns a data.frame containing the smoothed scores (including
spatially smoothed scores, if applicable) as well as other useful
sarks parameters for one or more specified input sequences
(blocks).
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)
filters <- sarksFilters(halfWindow=4, spatialLength=0, minGini=1.1)
permDist <- permutationDistribution(sarks, 250, filters, seed=123)
thresholds <- permutationThresholds(filters, permDist, nSigma=2.0)
bi24 <- blockInfo(sarks, '24', filters, thresholds)

}
\references{
Wylie, D.C., Hofmann, H.A., and Zemelman, B.V. (2019)
    SArKS: de novo discovery of gene expression regulatory motif
    sites and domains by suffix array kernel smoothing,
    Bioinformatics, Vol. 35(20), 3944-3952

    \url{https://academic.oup.com/bioinformatics/article-abstract/35/20/3944/5418797}
}
