% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethodSangerRead.R
\name{SangerRead-class-generateReportSR}
\alias{SangerRead-class-generateReportSR}
\alias{generateReportSR,SangerRead-method}
\title{generateReportSR}
\usage{
\S4method{generateReportSR}{SangerRead}(
  object,
  outputDir,
  colors,
  navigationContigFN = NULL,
  navigationAlignmentFN = NULL
)
}
\arguments{
\item{object}{A SangerRead S4 instance.}

\item{outputDir}{The output directory of the generated HTML report.}

\item{colors}{A vector for users to set the colors of (A, T, C, G, else). 
There are three options for users to choose from. 
  1. "default":  (green, blue, black, red, purple). 
  2. "cb_friendly":  ((0, 0, 0), (199, 199, 199), (0, 114, 178), (213, 94, 0), (204, 121, 167)). 
  3. Users can set their own colors with a vector with five elements.}

\item{navigationContigFN}{The internal parameter passed to HTML report. Users should not modify this parameter on their own.}

\item{navigationAlignmentFN}{The internal parameter passed to HTML report. Users should not modify this parameter on their own.}
}
\value{
The output absolute path to the SangerRead's HTML file.
}
\description{
A SangerRead method which generates final reports of the SangerRead instance.
}
\examples{
data("sangerReadFData")
\dontrun{
generateReportSR(sangerReadFData, "~/Documents")
generateReportSR(sangerReadFData, colors="cb_friendly")}
}
