% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normaliseByPermutation.R
\name{normalise_by_permu}
\alias{normalise_by_permu}
\title{Normalise test perturbation scores by permutation result and compute
permutation p-values}
\usage{
normalise_by_permu(
  permutedScore,
  testScore,
  pAdj_method = "fdr",
  sortBy = c("gs_name", "sample", "pvalue")
)
}
\arguments{
\item{permutedScore}{A list. Output of \code{generate_permuted_scores}}

\item{testScore}{A \code{data.frame}. Output of \code{pathway_pert}}

\item{pAdj_method}{Method for adjusting p-values for multiple comparisons.
See \code{?p.adjust} for methods available. Default to FDR.}

\item{sortBy}{Sort the output by p-value, gene-set name or sample names.}
}
\value{
A \code{data.frame}
}
\description{
Normalise test perturbation scores by permutation result and compute
permutation p-values
}
\details{
Normalise the test perturbation scores generated by \code{weight_ss_fc()}
through the permuted perturbation scores derived from the
\code{generate_permuted_scores()} function. The mean absolute deviation(MAD) and
median of perturbation scores for each pathway are firstly derived from the
permuted perturbation scores. The test perturbation scores are then converted
to robust z-scores using MADs and medians calculated.

Additionally, by assessing the proportion of permuted scores that are more
extreme than the test perturbation score within each pathway, the permuted
p-value of individual test perturbation scores will be computed.
}
\examples{
\dontrun{
load(system.file("extdata", "gsTopology.rda", package = "sSNAPPY"))
data(metadata_example)
data(logCPM_example)
metadata_example <- dplyr::mutate(metadata_example, treatment = factor(
   treatment, levels = c("Vehicle", "E2+R5020", "R5020")))
ls <- weight_ss_fc(logCPM_example, metadata = metadata_example,
groupBy = "patient", sampleColumn = "sample", treatColumn = "treatment")

# compute raw gene-wise perturbation scores
genePertScore <- raw_gene_pert(ls$weighted_logFC, gsTopology)

# sum gene-wise perturbation scores to derive the pathway-level
# single-sample perturbation scores
pathwayPertScore <- pathway_pert(genePertScore, ls$weighted_logFC)

# simulate the null distribution of scores through sample permutation
permutedScore <- generate_permuted_scores(logCPM_example,
gsTopology = gsTopology, weight = ls$weight)

# normlise the test perturbation scores using the permutation results
normalisedScores <- normalise_by_permu(permutedScore, pathwayPertScore,
sortBy = "pvalue")
 }
}
