% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotlib.R
\name{scatterPlot}
\alias{scatterPlot}
\title{scatterPlot
Plot GO terms as scattered points.}
\usage{
scatterPlot(
  simMatrix,
  reducedTerms,
  algorithm = c("pca", "umap"),
  onlyParents = FALSE,
  size = "score",
  addLabel = TRUE,
  labelSize = 3
)
}
\arguments{
\item{simMatrix}{a (square) similarity matrix.}

\item{reducedTerms}{a data.frame with the reduced terms from reduceSimMatrix()}

\item{algorithm}{algorithm for dimensionality reduction. Either pca or umap.}

\item{onlyParents}{plot only parent terms. Point size is the number of
aggregated terms under the parent.}

\item{size}{what to use as point size. Can be either GO term's "size" or
"score".}

\item{addLabel}{add labels with the most representative term of the group.}

\item{labelSize}{text size in the label.}
}
\value{
ggplot2 object ready to be printed (or manipulated)
}
\description{
scatterPlot
Plot GO terms as scattered points.
}
\details{
Distances between points represent the similarity between terms.
Axes are the first 2 components of applying one of this dimensionality
reduction algorithms:
  - a PCoA to the (di)similarity matrix.
  - a UMAP (Uniform Manifold Approximation and Projection,[1])
Size of the point represents the provided scores or, in its absence, the number
of genes the GO term contains.
}
\examples{
go_analysis <- read.delim(system.file("extdata/example.txt", package="rrvgo"))
simMatrix <- calculateSimMatrix(go_analysis$ID, orgdb="org.Hs.eg.db", ont="BP", method="Rel")
scores <- setNames(-log10(go_analysis$qvalue), go_analysis$ID)
reducedTerms <- reduceSimMatrix(simMatrix, scores, threshold=0.7, orgdb="org.Hs.eg.db")
scatterPlot(simMatrix, reducedTerms)
}
\references{
[1] Konopka T (2022). _umap: Uniform Manifold Approximation and Projection_. R package version 0.2.8.0, \url{https://CRAN.R-project.org/package=umap}.
}
