% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrvgo.R
\name{calculateSimMatrix}
\alias{calculateSimMatrix}
\title{calculateSimMatrix
Calculate the score similarity matrix between terms}
\usage{
calculateSimMatrix(
  x,
  orgdb,
  keytype = "ENTREZID",
  semdata = GOSemSim::godata(annoDb = orgdb, ont = ont, keytype = keytype),
  ont = c("BP", "MF", "CC"),
  method = c("Resnik", "Lin", "Rel", "Jiang", "Wang"),
  include_terms_without_IC = FALSE
)
}
\arguments{
\item{x}{vector of GO terms}

\item{orgdb}{one of org.* Bioconductor packages (the package name, or the
package itself)}

\item{keytype}{keytype passed to AnnotationDbi::keys to retrieve GO terms 
associated to gene ids in your orgdb}

\item{semdata}{object with prepared GO DATA for measuring semantic similarity}

\item{ont}{ontology. One of c("BP", "MF", "CC")}

\item{method}{distance method. One of the supported methods by GOSemSim:
c("Resnik", "Lin", "Rel", "Jiang", "Wang")}

\item{include_terms_without_IC}{whether to include terms for which there's no
Information Content in OrgDb. NOTE: Including them can mess up with the
algorithm that aggregates the distances. Default: FALSE.}
}
\value{
a square matrix with similarity scores between terms
}
\description{
calculateSimMatrix
Calculate the score similarity matrix between terms
}
\details{
All similarity measures available are those implemented in the
[GOSemSim package](https://www.bioconductor.org/packages/release/bioc/html/GOSemSim.html),
namely the Resnik, Lin, Relevance, Jiang and Wang methods. See the
[Semantic Similarity Measurement Based on GO](https://www.bioconductor.org/packages/release/bioc/vignettes/GOSemSim/inst/doc/GOSemSim.html#semantic-similarity-measurement-based-on-go)
section from the GOSeSim documentation for more details.
}
\examples{
go_analysis <- read.delim(system.file("extdata/example.txt", package="rrvgo"))
simMatrix <- calculateSimMatrix(go_analysis$ID, orgdb="org.Hs.eg.db", ont="BP", method="Rel")
}
