% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/oplsMultiDataSet-methods.R
\name{getMset}
\alias{getMset}
\alias{getMset,}
\alias{oplsMultiDataSet-method}
\alias{getMset,oplsMultiDataSet-method}
\title{getMset method}
\usage{
getMset(object)

\S4method{getMset}{oplsMultiDataSet}(object)
}
\arguments{
\item{object}{An S4 object of class \code{oplsMultiDataSet}, created by \code{opls}
function applied to a MultiDataSet}
}
\value{
An S4 object of class \code{MultiDataSet}.
}
\description{
Extracts the complemented MultiDataSet when opls has been applied to a MultiDataSet
}
\examples{
data(NCI60)
nci.mds <- NCI60[["mds"]]
# Restricting to the 'agilent' and 'hgu95' datasets
nci.mds <- nci.mds[, c("agilent", "hgu95")]
# Restricting to the 'ME' and 'LE' cancer types
sampleNamesVc <- Biobase::sampleNames(nci.mds[["agilent"]])
cancerTypeVc <- Biobase::pData(nci.mds[["agilent"]])[, "cancer"]
nci.mds <- nci.mds[sampleNamesVc[cancerTypeVc \%in\% c("ME", "LE")], ]
# Principal Component Analysis of each data set
nci.pca <- opls(nci.mds)
# Getting the MultiDataSet with additional info. in pData and fData
nci.mds <- getMset(nci.pca)
}
