% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleCoeditedRegion.R
\name{SingleCoeditedRegion}
\alias{SingleCoeditedRegion}
\title{Extracts contiguous co-edited genomic regions from a single 
  genomic region.}
\usage{
SingleCoeditedRegion(
  region_df,
  rnaEditMatrix,
  output = c("GRanges", "dataframe"),
  rDropThresh_num = 0.4,
  minPairCorr = 0.1,
  minSites = 3,
  method = c("spearman", "pearson"),
  minEditFreq = 0.05,
  returnAllSites = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{region_df}{A data frame with the input genomic region. Please make 
sure columns \code{seqnames}, \code{start}, and \code{end} are included in
the data frame.}

\item{rnaEditMatrix}{A matrix (or data frame) of RNA editing level values on
individual sites, with row names as site IDs in the form of
"chrAA:XXXXXXXX", and column names as sample IDs. Please make sure to
follow the format of example dataset (\code{data(rnaedit_df)}).}

\item{output}{Type of output data, can be "GRanges" or "dataframe". Defaults
to "GRanges".}

\item{rDropThresh_num}{Threshold for minimum correlation between RNA editing
levels of one site and the mean RNA editing levels of the rest of the 
sites. Please set a number between 0 and 1. Defaults to 0.4.}

\item{minPairCorr}{Minimum pairwise correlation coefficient of a cluster
is used as a filter to select clusters for output. Only clusters with all 
pairwise correlations between sites more than \code{minPairCorr} will be 
selected for output. 
To use this filter, set this argument to a number between -1 and 1
(defaults to 0.1). To turn it off, please set the argument to -1.}

\item{minSites}{Minimum number of sites to be considered a region. Only
regions with more than \code{minSites} number of sites will be returned.}

\item{method}{Method for computing correlations. Defaults to 
\code{"spearman"}.}

\item{minEditFreq}{Threshold for minimum percentage of samples for a given 
site. The \code{r_drop} value of the sites with frequency lower than 
\code{minEditFreq} will be set as NA. Please set a number between 0 and 1. 
Defaults to 0.05.}

\item{returnAllSites}{When no co-edited region is found in
an input genomic region, \code{returnAllSites = TRUE} indicates
outputting all the sites from the input region, while
\code{returnAllSites = FALSE} indicates not returning any site from the
input region. Defaults to FALSE.}

\item{verbose}{Should messages and warnings be displayed? Defaults to TRUE,
but is set to FALSE when called from within \code{AllCoeditedRegions()}.}
}
\value{
When \code{output} is set to
  \code{"GRanges"}, a GRanges object with \code{seqnames}, \code{ranges} and
  \code{strand} of the contiguous co-edited regions will be returned. 
  
  When \code{output} is set to \code{"dataframe"}, a data frame with
  following columns will be returned:
  \itemize{
    \item{\code{site} : }{site ID.}
    \item{\code{chr} : }{chromosome.}
    \item{\code{pos} : }{genomic location.}
    \item{\code{r_drop} : }{the correlation between RNA editing levels of 
    one site and the mean RNA editing levels of the rest of the sites.}
    \item{\code{keep} : }{indicator for co-edited sites, The sites with
    \code{keep = 1} belong to the contiguous and co-edited region.}
    \item{\code{keep_contiguous} : }{contiguous co-edited region number.}
    \item{\code{regionMinPairwiseCor} : }{the minimum pairwise correlation 
    of a co-edited region.}
    \item{\code{keep_regionMinPairwiseCor} : }{equals 1 for contiguous
    co-edited subregions. The regions with \code{keepminPairwiseCor = 1}
    are the ones that passed the \code{regionMinPairwiseCor} filter and will 
    be returned as a co-edited sub-region.}
  }
}
\description{
Extracts contiguous co-edited genomic regions from an input
  genomic region.
}
\examples{
  data(rnaedit_df)
  
  exm_region <- data.frame(
    seqnames = "chr1",
    start =  28691093,
    end = 28826881, 
    stringsAsFactors = FALSE
  )
  
  SingleCoeditedRegion(
    region_df = exm_region,
    rnaEditMatrix = rnaedit_df,
    minPairCorr = 0.25,
    output = "dataframe",
    method = "spearman"
  )
   
}
\keyword{internal}
