% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_MakeModelFormula.R
\name{MakeModelFormula}
\alias{MakeModelFormula}
\title{Make model formula.}
\usage{
MakeModelFormula(
  responses_char,
  covariates_char = NULL,
  respType = c("binary", "continuous", "survival")
)
}
\arguments{
\item{responses_char}{A character vector of the response variable.}

\item{covariates_char}{A character vector of the covariate variables.}

\item{respType}{Type of outcome. Defaults to \code{"binary"}.}
}
\value{
A character vector of the model formula.
}
\description{
Make model formula for different types of phenotype responses.
}
\details{
When \code{respType} is set as \code{"survival"},
  \code{"surv_object"} is only a placeholder here , which will be defined 
  later in \code{TestSingleRegion()}.
}
\examples{

MakeModelFormula(
  responses_char = "age",
  covariates_char = c("sex", "tumor_type"),
  respType = "continuous"
)

MakeModelFormula(
  responses_char = "sample_type",
  covariates_char = c("sex", "tumor_type"),
  respType = "binary"
)

MakeModelFormula(
  responses_char = c("OS.time", "OS"),
  covariates_char = c("sex", "tumor_type"),
  respType = "survival"
)

}
\keyword{internal}
