% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjusting_HLToInt.r
\name{adjusting_HLToInt}
\alias{adjusting_HLToInt}
\title{adjusting_HLToInt Creates one table merging HL and intensity fragments
with genome annotation}
\usage{
adjusting_HLToInt(data, Strand = c("+", "-"), annotation)
}
\arguments{
\item{data}{data frame: data frame combined data by column}

\item{Strand}{string: either "+" or "-"}

\item{annotation}{data frame: data frame from processed gff3 file.}
}
\value{
The data frame with the corresponding columns:
\describe{
\item{position:}{Integer, position of the first fragment}
\item{region:}{String, region annotation covering the fragments}
\item{gene:}{String, gene annotation covering the fragments}
\item{locus_tag:}{String, locus_tag annotation covering the fragments}
\item{strand:}{Boolean. The bin/probe specific strand (+/-)}
\item{fragment_HL:}{String, HL fragments}
\item{fragment_int:}{String, intensity fragments}
\item{position_frg_int:}{Integer, position of the first fragment and
the last position of the last fragment}
\item{mean_HL_fragment:}{Integer, mean of the HL of the fragments
involved}
\item{mean_int_fragment:}{Integer, mean of the intensity of the
fragments involved}
\item{log2FC(decay_rate):}{Integer, log2FC(decay(condition1)/
decay(condition2))}
\item{log2FC(synthesis_rate):}{Integer, sum of log2FC(decay_rate) and
log2FC(intensity)}
\item{intensity_FC:}{Integer, log2FC(mean(intensity(condition1))/mean(
intensity(condition2)))}
\item{Log2FC(HL)+Log2FC(int):}{Integer, sum of log2FC(decay_rate) and
log2FC(intensity)}
\item{p_value:}{String, indicated by "*" means at least one fragment
either HL fragment or intensity fragment has a significant p_value}
}
}
\description{
'adjusting_HLToInt' merges HL and intensity segments adapting the positions
to each other and combining to the genome annotation.
To make HL and intensity segments comparable, log2FC(HL) is used to generate
the data frame instead of distance.
The fragments should have a significant p_value from t-test at least from one
segmentation, either HL or intensity.
}
\details{
The functions used are:
\enumerate{
\item p_value_function extracts and return the p_values of HL and intensity
segments respectively.
\item eliminate_outlier_hl eliminates outliers from HL fragments.
\item eliminate_outlier_int eliminates outliers from intensity fragments.
\item mean_length_int calculates the mean of the log2FC(intensity) fragments
adapted to HL_fragments and their lengths
\item mean_length_hl calculates the mean of log2FC(HL) fragments adapted to the
intensity fragments and their lengths.
\item calculating_rate calculates decay rate and log2FC(intensity). Both are
used to calculate synthesis rate.
}
}
\examples{
data(stats_df_comb_minimal)
data(annot_g)
df_mean_minimal <- adjusting_HLToInt(data = stats_df_comb_minimal,
annotation = annot_g[[1]])

}
