% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translationalEfficiency.R
\name{translationalEfficiency}
\alias{translationalEfficiency}
\title{Translational Efficiency}
\usage{
translationalEfficiency(
  x,
  window,
  RPFsampleOrder,
  mRNAsampleOrder,
  pseudocount = 1,
  log2 = FALSE,
  normByLibSize = FALSE,
  shrink = FALSE,
  ...
)
}
\arguments{
\item{x}{Output of \link{getFPKM} or \link{normByRUVs}.
if window is set, it must be output of \link{coverageDepth}.}

\item{window}{numeric(1). window size for maximal counts.}

\item{RPFsampleOrder, mRNAsampleOrder}{Sample order of RPFs and mRNAs.
The parameters are used to make sure that the order of RPFs and mRNAs in
cvgs is corresponding samples.}

\item{pseudocount}{The number will be add to sum of reads count to avoid X/0.}

\item{log2}{Do log2 transform or not.}

\item{normByLibSize}{Normalization by library size or not.
If window size is provided and normByLibSize is set to TRUE,
the coverage will be normalized by library size.}

\item{shrink}{Shrink the TE or not.}

\item{...}{Parameters will be passed to \code{ash} function from \code{ashr}.}
}
\value{
A list with RPFs, mRNA levels and TE as a matrix with
translational efficiency
}
\description{
Calculate Translational Efficiency (TE). TE is defined as
the ratios of the absolute level of ribosome occupancy divided by RNA levels
for transcripts.
}
\examples{
\dontrun{
path <- system.file("extdata", package="ribosomeProfilingQC")
RPFs <- dir(path, "RPF.*?\\\\.[12].bam$", full.names=TRUE)
RNAs <- dir(path, "mRNA.*?\\\\.[12].bam$", full.names=TRUE)
gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
cnts <- countReads(RPFs, RNAs, gtf, level="gene")
fpkm <- getFPKM(cnts)
te <- translationalEfficiency(fpkm)
}
}
