% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spliceEvent.R
\name{spliceEvent}
\alias{spliceEvent}
\title{Get splicing events}
\usage{
spliceEvent(coverage, group1, group2)
}
\arguments{
\item{coverage}{Coverages of feature region with extensions.
Output of \link{coverageDepth}}

\item{group1, group2}{The sample names of group 1 and group 2}
}
\value{
A GRanges object of splice events.
}
\description{
Get differentical usage of alternative
Translation Initiation Sites,
alternative Polyadenylation Sites or
alternative splicing sites
}
\examples{
\dontrun{
path <- system.file("extdata", package="ribosomeProfilingQC")
RPFs <- dir(path, "RPF.*?\\\\.[12].bam$", full.names=TRUE)
gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
coverage <- coverageDepth(RPFs, gtf=gtf,
                  level="gene", region="feature with extension")
group1 <- c("RPF.KD1.1", "RPF.KD1.2")
group2 <- c("RPF.WT.1", "RPF.WT.2")
se <- spliceEvent(coverage, group1, group2)
}
}
