% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverageDepth.R
\name{coverageDepth}
\alias{coverageDepth}
\title{Extract coverage depth for gene level or transcript level}
\usage{
coverageDepth(
  RPFs,
  RNAs,
  gtf,
  level = c("tx", "gene"),
  bestpsite = 13,
  readsLen = c(28, 29),
  anchor = "5end",
  region = "cds",
  ext = 5000,
  ignore.seqlevelsStyle = FALSE,
  ...
)
}
\arguments{
\item{RPFs}{Bam file names of RPFs.}

\item{RNAs}{Bam file names of RNAseq.}

\item{gtf}{GTF file name for annotation or a TxDb object.}

\item{level}{Transcript or gene level.}

\item{bestpsite}{P site postion.}

\item{readsLen}{Reads length to keep.}

\item{anchor}{5end or 3end. Default is 5end.}

\item{region}{Annotation region. It could be "cds", "utr5", "utr3",
"exon", "transcripts", "feature with extension".}

\item{ext}{Extesion region for "feature with extension".}

\item{ignore.seqlevelsStyle}{Ignore the sequence name style detection or not.}

\item{...}{Parameters pass to
\link[txdbmaker:makeTxDbFromGFF]{makeTxDbFromGFF}}
}
\value{
A cvgd object with coverage depth.
}
\description{
Calculate the coverage depth for gene level or transcript level.
Coverage for RPFs will be the best P site coverage.
Coverage for RNAs will be the coverage for 5'end of reads.
}
\examples{
path <- system.file("extdata", package="ribosomeProfilingQC")
RPFs <- dir(path, "RPF.*?\\\\.[12].bam$", full.names=TRUE)
gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
cvgs <- coverageDepth(RPFs[1], gtf=gtf, level="gene")
}
