% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5D.R
\name{H5Dopen}
\alias{H5Dopen}
\title{Open an existing HDF5 dataset}
\usage{
H5Dopen(h5loc, name, dapl = NULL)
}
\arguments{
\item{h5loc}{An object of class \linkS4class{H5IdComponent} representing a H5
location identifier (file or group).}

\item{name}{Name of the dataset to open.}

\item{dapl}{An object of class \linkS4class{H5IdComponent} representing a H5 dataset access property list.}
}
\value{
An object of class \code{H5IdComponent} representing the opened dataset.
To prevent memory leaks this must be closed with a call to \code{\link[=H5Dclose]{H5Dclose()}}
when no longer needed.
}
\description{
Open an existing HDF5 dataset
}
\examples{
h5file <- tempfile(fileext = ".h5")
h5createFile(h5file)
h5createDataset(h5file, dataset = "A", dims = 10)

fid <- H5Fopen(h5file)
did <- H5Dopen(h5loc = fid, name = "A")
did

## rember to close open handles
H5Dclose(did)
H5Fclose(fid)

}
