% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5O.R
\name{H5Oopen}
\alias{H5Oopen}
\title{Open an object in an HDF5 file}
\usage{
H5Oopen(h5loc, name)
}
\arguments{
\item{h5loc}{An object of class \linkS4class{H5IdComponent}}

\item{name}{Path to the object to be opened.  This should be relative to
\code{h5loc} rather than the file.}
}
\value{
An object of class \linkS4class{H5IdComponent} if the open operation was
successful. \code{FALSE} otherwise.
}
\description{
Open an object in an HDF5 file
}
\examples{

h5File <- tempfile(pattern = "ex_H5O.h5")

# create an hdf5 file and write something
h5createFile(h5File)
h5createGroup(h5File, "foo")
B <- array(seq(0.1, 2.0, by = 0.1), dim = c(5, 2, 2))
h5write(B, h5File, "foo/B")

# reopen file and dataset and get object info
fid <- H5Fopen(h5File)
oid <- H5Oopen(fid, "foo")
H5Oget_num_attrs(oid)
H5Oclose(oid)
H5Fclose(fid)

}
\seealso{
\code{\link[=H5Oclose]{H5Oclose()}}
}
