% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{plotExwas}
\alias{plotExwas}
\title{Function to draw a plot of the pvalues stored in an \code{ExWAS} object}
\usage{
plotExwas(
  object,
  ...,
  subtitles,
  color,
  exp.order,
  labels,
  show.effective = TRUE
)
}
\arguments{
\item{object}{An \code{ExWAS} object which p-values will be plotted.}

\item{...}{Other objects of class \code{ExWAS}.}

\item{subtitles}{(optional) Characters used as "substitle" when more than one
\code{ExWAS} is given.}

\item{color}{(optional) Character vector of HTML colors, labeled with
family's names. Used to colore the exposures.}

\item{exp.order}{(optional) Character vector of exposures used to order
and subset the plot.}

\item{labels}{(optional) Character vector with the labels for each exposure.
It must be labeled vector.}

\item{show.effective}{(default \code{TRUE}) If set to \code{FALSE},
line showing effective test threshold is not shown.}
}
\value{
An object of class \code{ggplot}.
}
\description{
This function draws a sort of manhattan plots using the p-value of the
association of the exposures with phenotypes of an \code{ExWAS} object.
}
\examples{
data(exposome)
w1 <- exwas(expo[1:5, ], asthma~1, family = "binomial")
plotExwas(w1)
}
\seealso{
\link{exwas} as a constructor for \link{ExWAS} objects,
\link{extract} to obtain a table with the result of the ExWAS
}
