% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{plotEffect}
\alias{plotEffect}
\title{Function to draw a plot of the pvalues stored in an \code{ExWAS} object}
\usage{
plotEffect(x, y, select, labels, xlab, ylab)
}
\arguments{
\item{x}{An \code{ExWAS} object which effect will be ploted.}

\item{y}{(optional) Another \code{ExWAS} object. If provded its
effects will be ploted in Y-axis.}

\item{select}{(optional) Character with exposures to be shown.}

\item{labels}{(optional) Character vector with the labels for each exposure.
It must be labeled vector.}

\item{xlab}{(optional) Label for X-axis.}

\item{ylab}{(optional) Label for Y-axis.}
}
\value{
An object of class \code{ggplot}.
}
\description{
This function draws a sort of manhattan plots using the p-value of the
association of the exposures with phenotypes of an \code{ExWAS} object.
}
\examples{
data(exposome)
w1 <- exwas(expo[1:5, ], asthma~1, family = "binomial")
w2 <- exwas(expo[1:5, ], asthma~sex+age, family = "binomial")
plotEffect(w1, w2)
}
\seealso{
\link{exwas} as a constructor for \link{ExWAS} objects,
\link{extract} to obtain a table with the result of the ExWAS
}
