% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializeResults.R
\name{initializeResults}
\alias{initializeResults}
\title{Initialize RegspliceResults object.}
\usage{
initializeResults(rs_data)
}
\arguments{
\item{rs_data}{\code{\linkS4class{RegspliceData}} object. This should contain gene IDs
in a column named \code{gene_IDs} in the row meta-data, which can be accessed with 
the accessor function \code{\link{rowData}}.}
}
\value{
Returns a \code{\linkS4class{RegspliceResults}} object containing gene IDs 
  only.
}
\description{
Initialize a \code{RegspliceResults} object, which will contain the results of the 
\code{regsplice} analysis.
}
\details{
Creates a \code{\linkS4class{RegspliceResults}} object containing gene names only. 
This object will subsequently be populated using the functions 
\code{\link{fitRegMultiple}}, \code{\link{fitNullMultiple}}, 
\code{\link{fitFullMultiple}}, and \code{\link{LRTests}}.

Previous step: Calculate \code{limma-voom} transformation and weights with 
\code{\link{runVoom}}.
Next step: Fit models with \code{\link{fitRegMultiple}}, 
\code{\link{fitNullMultiple}}, and \code{\link{fitFullMultiple}}.
}
\examples{
file_counts <- system.file("extdata/vignette_counts.txt", package = "regsplice")
data <- read.table(file_counts, header = TRUE, sep = "\t", stringsAsFactors = FALSE)
head(data)

counts <- data[, 2:7]
tbl_exons <- table(sapply(strsplit(data$exon, ":"), function(s) s[[1]]))
gene_IDs <- names(tbl_exons)
n_exons <- unname(tbl_exons)
condition <- rep(c("untreated", "treated"), each = 3)

rs_data <- RegspliceData(counts, gene_IDs, n_exons, condition)

rs_data <- filterZeros(rs_data)
rs_data <- filterLowCounts(rs_data)
rs_data <- runNormalization(rs_data)
rs_data <- runVoom(rs_data)

rs_results <- initializeResults(rs_data)

}
\seealso{
\code{\linkS4class{RegspliceData}} \code{\linkS4class{RegspliceResults}} 
  \code{\link{fitRegMultiple}} \code{\link{fitNullMultiple}} 
  \code{\link{fitFullMultiple}} \code{\link{LRTests}} \code{\link{summaryTable}}
}
