% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDesignMatrix.R
\name{createDesignMatrix}
\alias{createDesignMatrix}
\title{Create design matrix.}
\usage{
createDesignMatrix(condition, n_exons)
}
\arguments{
\item{condition}{Experimental conditions for each sample (character or numeric vector,
or factor).}

\item{n_exons}{Number of exons in the gene (integer).}
}
\value{
Returns a model design matrix for the gene, in the format required by the 
  \code{regsplice} model fitting functions.
}
\description{
Create a model design matrix for a single gene.
}
\details{
Creates a model design matrix for a single gene in the format required by the 
\code{regsplice} model fitting functions. Required inputs are the experimental 
conditions (groups) for each sample, and the number of exons in the gene.

The design matrix includes main effect terms for each exon and each sample, and
interaction terms between the exons and conditions.

Note that the design matrix does not include main effect terms for the conditions,
since these are absorbed into the main effect terms for the samples. In addition, the
design matrix does not include an intercept column, since it is simpler to let the
model fitting functions add an intercept term later.

The model fitting functions in subsequent steps call this function once for each gene.
}
\examples{
condition <- rep(c(0, 1), each = 3)
n_exons <- 10
X <- createDesignMatrix(condition, n_exons)

}
\seealso{
\code{\link{fitRegMultiple}} \code{\link{fitNullMultiple}} 
  \code{\link{fitFullMultiple}} \code{\link{LRTests}}
}
