% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapRegions.R
\name{overlapRegions}
\alias{overlapRegions}
\title{Overlap Regions}
\usage{
overlapRegions(A, B, colA=NULL, colB=NULL, type="any", min.bases=1, min.pctA=NULL, min.pctB=NULL, get.pctA=FALSE, get.pctB=FALSE, get.bases=FALSE, only.boolean=FALSE, only.count=FALSE, ...)
}
\arguments{
\item{A}{a region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{B}{a region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{colA}{numeric vector indicating which columns of A the results will contain (default NULL)}

\item{colB}{numeric vector indicating which columns of B the results will contain (default NULL)}

\item{type}{\itemize{
\item{\code{AinB}: the region in A is contained in a region in B}
\item{\code{BinA}: the region in B is contained in A}
\item{\code{within}: the region in A or B is contained in a region in the other region set}
\item{\code{equal}: the region in A has the same chromosome, start and end as a region in B}
\item{\code{AleftB}: the end of the region from A overlaps the beginning of a region in B}
\item{\code{ArightB}: the start of a region from A overlaps the end of a region in B}
\item{\code{any}: any kind of overlap is returned}
}}

\item{min.bases}{numeric minimun number of bp accepted to define a overlap (default 1)}

\item{min.pctA}{numeric minimun percentage of bases of A accepted to define a overlap (default NULL)}

\item{min.pctB}{numeric minimun percentage of bases of B accepted to define a overlap (default NULL)}

\item{get.pctA}{boolean if TRUE add a column in the results indicating the number percentage of A are involved in the overlap (default FALSE)}

\item{get.pctB}{boolean if TRUE add a column in the results indicating the number percentage of B are involved in the overlap (default FALSE)}

\item{get.bases}{boolean if TRUE add in the results the number of overlapped bases (default FALSE)}

\item{only.boolean}{boolean if TRUE devolve as result a boolean vector containing the overlap state of each regions of A (default FALSE)}

\item{only.count}{boolean if TRUE devolve as result the number of regions of A overlapping with B}

\item{...}{any additional parameter (are there any left?)}
}
\value{
the default results is a \code{\link{data.frame}} with at least 5 columns "chr" indicating the chromosome of the appartenence of each overlap, "startA", "endA", "startB", "endB", indicating the coordinates of the region A and B for each overlap
"type" that describe the nature of the overlap (see arguments "type") eventually other columns can be added (see see arguments "colA", "colB", "get.pctA", "get.pctB", "get.bases")
}
\description{
return overlap between 2 regios set A and B
}
\note{
The implementation uses when possible the \code{\link{countOverlaps}} function from \code{IRanges} package.
}
\examples{
A <- data.frame("chr1", c(1, 5, 20, 30), c(8, 13, 28, 40), x=c(1,2,3,4), y=c("a", "b", "c", "d"))

B <- data.frame("chr1", 25, 35)

overlapRegions(A, B)

}
\seealso{
\code{\link{plotRegions}}, \code{\link{toDataframe}}, \code{\link{toGRanges}}, \code{\link{subtractRegions}}, \code{\link{splitRegions}}, \code{\link{extendRegions}}, \code{\link{commonRegions}}, \code{\link{mergeRegions}}, \code{\link{joinRegions}}
}
