% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterChromosomes.R
\name{filterChromosomes}
\alias{filterChromosomes}
\title{filterChromosomes}
\usage{
filterChromosomes(A, organism="hg", chr.type="canonical", keep.chr=NULL)
}
\arguments{
\item{A}{a region set in any of the formats accepted by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{organism}{a character indicating the organism from which to get the predefined chromosome sets. It can be the organism code as used in \code{\link{BSgenome}} (e.g. hg for human, mm for mouse...) or the full genome assembly identifier, since any digit will be removed to get the organism code.}

\item{chr.type}{a character indicating the specific chromosome set to be used. Usually "autosomal" or "canonical", althought other values could be available for certain organisms.}

\item{keep.chr}{is a character vector stating the names of the chromosomes to keep. Any chromosome not in the vector will be filtered out. If keep.chr is supplied, organism and chr.type are ignored.}
}
\value{
A \code{\link{GRanges}} object containing only the regions in the original region set belonging to the selected chromosomes. All regions in non selected chromosomes are removed.
}
\description{
Filters the chromosomes in a region set. It can either filter using a predefined chromosome set (e.g. "autosomal
 chromosomes in Homo sapiens") or using a custom chromosome set (e.g. only chromosomes "chr22" and "chrX")
}
\examples{

g <- getGenomeAndMask("hg19")$genome
listChrTypes()
g <- filterChromosomes(g, chr.type="autosomal", organism="hg19")
g <- filterChromosomes(g, keep.chr=c("chr1", "chr2", "chr3"))


}
\seealso{
\code{\link{getGenomeAndMask}}, \code{\link{listChrTypes}} \code{\link{getChromosomesByOrganism}}
}
