% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sig_pcs.R
\name{get_sig_pcs}
\alias{get_sig_pcs}
\title{Get significant principal components}
\usage{
get_sig_pcs(x, pc_method = c("mp", "gd"), verbose = FALSE)
}
\arguments{
\item{x}{A data frame or matrix of methylation values;
rows = features, columns = samples}

\item{pc_method}{String indicating the method for estimating dimension;
"gd" = Gavish-Donoho (default), "mp" = Marchenko-Pastur}

\item{verbose}{Boolean; print output statements}
}
\value{
List containing four elements;
sig_pcs = significant PCs,
percent_var = percent variance explained,
loadings = PC loadings,
est_dim = estimated dimension
}
\description{
Get significant principal components
}
\examples{
x <- diag(4)
get_sig_pcs(x, "gd")
}
