% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_counts.R
\name{is_paired_end}
\alias{is_paired_end}
\title{Guess whether the samples are paired end}
\usage{
is_paired_end(
  x,
  avg_mapped_read_length = "recount_qc.star.average_mapped_length",
  avg_read_length = "recount_seq_qc.avg_len"
)
}
\arguments{
\item{x}{Either a
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
created by \code{create_rse()} or the sample metadata created by
\code{read_metadata()}.}

\item{avg_mapped_read_length}{A \code{character(1)} specifying the metdata column
name that contains the average fragment length after aligning. This is
typically twice the average read length for paired-end reads.}

\item{avg_read_length}{A \code{character(1)} specifying the metadata column
name that contains the average read length prior to aligning.}
}
\value{
A \code{logical()} vector specifying whether each sample was likely
paired-end or not.
}
\description{
Based on two alignment metrics, this function guesses the samples are paired
end or not.
}
\examples{

## Download the metadata for SRP009615, a single-end study
SRP009615_meta <- read_metadata(
    metadata_files = file_retrieve(
        locate_url(
            "SRP009615",
            "data_sources/sra",
        )
    )
)

## Are the samples paired end?
is_paired_end(SRP009615_meta)

## Download the metadata for DRP000499, a paired-end study
DRP000499_meta <- read_metadata(
    metadata_files = file_retrieve(
        locate_url(
            "DRP000499",
            "data_sources/sra",
        )
    )
)
is_paired_end(DRP000499_meta)
}
\seealso{
Other count transformation functions: 
\code{\link{compute_read_counts}()},
\code{\link{compute_scale_factors}()},
\code{\link{transform_counts}()}
}
\concept{count transformation functions}
