% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployCustomCSS.R
\name{deployCustomCSS}
\alias{deployCustomCSS}
\title{Deploy a custom CSS}
\usage{
deployCustomCSS(path = "style.css", h2.col = "#87b13f", h3.col = "#1a81c2")
}
\arguments{
\item{path}{String containing the path to the output CSS file.}

\item{h2.col}{String containing the color to use for the section headers.}

\item{h3.col}{String containing the color to use for the subsection headers.}
}
\value{
The CSS file is overwritten at \code{path}.
A \code{NULL} is invisibly returned.
}
\description{
Deploy a custom CSS to change the colors of the book's section headers, mostly to add some flavor to the book.
}
\details{
We quickly learned that it was unwise to be too adventurous with the colors.
In particular, changing the colors of the table of contents was quite distracting.
Altering the colors of the section headers provides a tasteful level of customization,
with the default colors set (almost) to the Bioconductor color palette.
}
\examples{
fname <- tempfile(fileext=".css")
deployCustomCSS(fname)
cat(readLines(fname), sep="\n")

}
\author{
Aaron Lun,
based on work by Rob Amezquita and Kevin Rue-Albrecht
}
