% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiseqr_helpers.R
\name{fixMixture}
\alias{fixMixture}
\title{Format the mixture matrix before deconvolution}
\usage{
fixMixture(mix.mat, arrays = FALSE)
}
\arguments{
\item{mix.mat}{Matrix or data.frame with RNA-seq gene TPM or microarray
expression values for all samples to be deconvoluted, with gene
symbols as row names and sample IDs as column names. Expression
levels should be on non-log scale.}

\item{arrays}{Logical value. Should be set to TRUE if the expression data
are from microarrays. For RNA-seq data, this has to be FALSE (default value).}
}
\value{
The input matrix transformed to the natural scale (if needed),
with fixed gene names on the rows, and TPM (for RNA-seq) or quantile (for microarrays)
normalized.
}
\description{
Format the mixture matrix before deconvolution
}
\examples{

data(dataset_racle)
# mixture.fix <- quantiseqr:::fixMixture(dataset_racle$expr_mat)
}
