% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_local.R
\name{prepareJunctionQuantSTAR}
\alias{prepareJunctionQuantSTAR}
\alias{prepareGeneQuantSTAR}
\title{Prepare user-provided files to be loaded into psichomics}
\usage{
prepareJunctionQuantSTAR(..., startOffset = -1, endOffset = +1)

prepareGeneQuantSTAR(
  ...,
  strandedness = c("unstranded", "stranded", "stranded (reverse)")
)
}
\arguments{
\item{...}{Character: path of (optionally named) input files (see Examples)}

\item{startOffset}{Numeric: value to offset start position}

\item{endOffset}{Numeric: value to offset end position}

\item{strandedness}{Character: strandedness of RNA-seq protocol; may be one
of the following: \code{unstraded}, \code{stranded} or
\code{stranded (reverse)}}
}
\value{
Prepared file (if \code{output != NULL}) and object
}
\description{
Prepare user-provided files to be loaded into psichomics
}
\examples{
\dontrun{
prepareJunctionQuant("Control rep1"=junctionFile1,
                     "Control rep2"=junctionFile2,
                     "KD rep1"=junctionFile3,
                     "KD rep2"=junctionFile4)
}
\dontrun{
prepareGeneQuant("Control rep1"=geneCountFile1,
                 "Control rep2"=geneCountFile2,
                 "KD rep1"=geneCountFile3,
                 "KD rep2"=geneCountFile4)
}
}
\keyword{internal}
