% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{processSurvival}
\alias{processSurvival}
\title{Check if survival analyses successfully completed or returned errors}
\usage{
processSurvival(session, ...)
}
\arguments{
\item{session}{Shiny session}

\item{...}{
  Arguments passed on to \code{\link[=processSurvTerms]{processSurvTerms}}
  \describe{
    \item{\code{censoring}}{Character: censor using \code{left}, \code{right},
\code{interval} or \code{interval2}}
    \item{\code{scale}}{Character: rescale the survival time to \code{days},
\code{weeks}, \code{months} or \code{years}}
    \item{\code{formulaStr}}{Character: formula to use}
    \item{\code{coxph}}{Boolean: fit a Cox proportional hazards regression model?}
    \item{\code{survTime}}{\code{survTime} object: times to follow up, time start, time
stop and event (optional)}
    \item{\code{group}}{Character: group relative to each subject}
    \item{\code{clinical}}{Data frame: clinical data}
    \item{\code{event}}{Character: name of column containing time of the event of
interest}
    \item{\code{timeStart}}{Character: name of column containing starting time of the
interval or follow up time}
    \item{\code{timeStop}}{Character: name of column containing ending time of the
interval (only relevant for interval censoring)}
    \item{\code{followup}}{Character: name of column containing follow up time}
  }}
}
\value{
List with survival analysis results
}
\description{
Check if survival analyses successfully completed or returned errors
}
\keyword{internal}
