% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{parseCategoricalGroups}
\alias{parseCategoricalGroups}
\title{Parse categorical columns in a data frame}
\usage{
parseCategoricalGroups(df)
}
\arguments{
\item{df}{Data frame}
}
\value{
List of lists containing values based on rownames of \code{df}
}
\description{
Retrieve elements grouped by their unique group based on each categorical
column
}
\examples{
df <- data.frame("race"=c("caucasian", "caucasian", "asian"),
                 "gender"=c("male", "female", "male"))
rownames(df) <- paste("subject", 1:3)
parseCategoricalGroups(df)
}
\seealso{
\code{\link{testGroupIndependence}()} and
\code{\link{plotGroupIndependence}()}
}
