% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialInternalMetrics.R
\name{getSpatialInternalMetrics}
\alias{getSpatialInternalMetrics}
\alias{getSpatialInternalMetrics,missing-method}
\alias{getSpatialInternalMetrics,SpatialExperiment-method}
\title{Compute internal metrics for spatial data}
\usage{
getSpatialInternalMetrics(
  object = NULL,
  labels,
  location = NULL,
  k = 6,
  level = "class",
  metrics = c("CHAOS", "PAS", "ELSA"),
  ...
)

\S4method{getSpatialInternalMetrics}{missing}(
  object = NULL,
  labels,
  location = NULL,
  k = 6,
  level = "class",
  metrics = c("CHAOS", "PAS", "ELSA"),
  ...
)

\S4method{getSpatialInternalMetrics}{SpatialExperiment}(
  object = NULL,
  labels,
  location = NULL,
  k = 6,
  level = "class",
  metrics = c("CHAOS", "PAS", "ELSA"),
  ...
)
}
\arguments{
\item{object}{The main input. Can be a \code{SpatialExperiment} object or missing
(when using \code{labels}, and \code{location} directly).}

\item{labels}{When \code{object} is missing: a vector containing the labels of the
predicted clusters. Must be a vector of characters, integers, numerics, or a
factor, but not a list. When \code{object} is a \code{SpatialExperiment} object: the
column name in \code{colData(object)} containing the labels.}

\item{location}{A numerical matrix containing the location information, with
rows as samples and columns as location dimensions.}

\item{k}{The size of the spatial neighborhood to look at for each spot.
This is used for calculating PAS and ELSA scores.}

\item{level}{The level to calculate the metrics. Options include \code{"element"},
\code{"class"} and \code{"dataset"}.}

\item{metrics}{The metrics to compute. See details.}

\item{...}{Optional params for \code{\link[=PAS]{PAS()}}.}
}
\value{
A data.frame of metrics.
}
\description{
A generic function to compute a selection of internal clustering evaluation
metrics for spatial data. It can be applied to raw components
(\code{labels}, \code{location}) or directly to a \code{SpatialExperiment} object.
}
\details{
The allowed values for \code{metrics} depend on the value of \code{level}:
\itemize{
\item If \code{level = "element"}, the allowed \code{metrics} are: \code{"PAS"}, \code{"ELSA"}.
\item If \code{level = "class"}, the allowed \code{metrics} are: \code{"CHAOS"}, \code{"PAS"},
\code{"ELSA"}.
\item If \code{level = "dataset"}, the allowed \code{metrics} are:
\itemize{
\item \code{"PAS"}: Proportion of abnormal spots (PAS score)
\item \code{"ELSA"}: Entropy-based Local indicator of Spatial Association
(ELSA score)
\item \code{"CHAOS"}: Spatial Chaos Score.
\item \code{"MPC"}: Modified partition coefficient
\item \code{"PC"}: Partition coefficient
\item \code{"PE"}: Partition entropy
}
}
}
\examples{
# Example with individual components
data(sp_toys)
data <- sp_toys
getSpatialInternalMetrics(labels=data$label, location=data[,c("x", "y")], 
                          k=6, level="class")

# Example with SpatialExperiment object
se_object <- SpatialExperiment::SpatialExperiment(assays=matrix(NA, 
                                             ncol = nrow(data[,c("x", "y")]), 
                                             nrow = ncol(data[,c("x", "y")])), 
                               spatialCoords=as.matrix(data[,c("x", "y")]))
SummarizedExperiment::colData(se_object) <- 
cbind(SummarizedExperiment::colData(se_object), 
      data.frame(label=data$label))
getSpatialInternalMetrics(object=se_object, labels="label", k=6, 
                          level="class")
}
