% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{findSpatialKNN}
\alias{findSpatialKNN}
\title{Find the k nearest spatial neighbors}
\usage{
findSpatialKNN(
  location,
  k,
  keep_ties = TRUE,
  useMedianDist = FALSE,
  BNPARAM = NULL
)
}
\arguments{
\item{location}{A numeric data matrix containing location information, where
rows are points and columns are location dimensions.}

\item{k}{The number of nearest neighbors to look at.}

\item{keep_ties}{A Boolean indicating if ties are counted once or not. If
TRUE, neighbors of the same distances will be included even if it means
returning more than \code{k} neighbors.}

\item{useMedianDist}{Use the median distance of the k nearest neighbor as
maximum distance to be included. Ignored if \code{keep_ties=FALSE}.}

\item{BNPARAM}{BNPARAM object passed to \code{\link[BiocNeighbors]{findKNN}}
specifying the kNN approximation method to use. Defaults to exact for small
datasets, and Annoy for larger ones.}
}
\value{
A list of indices.
}
\description{
For a given dataset, find the \code{k} nearest neighbors for each
object based on their spatial locations, with the option of handling ties.
}
\examples{
data(sp_toys)
data <- sp_toys
findSpatialKNN(data[,c("x", "y")], k=6)
}
