% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context-utils.R
\name{plyxp-context}
\alias{plyxp-context}
\alias{cols}
\alias{rows}
\alias{col_ctx}
\alias{row_ctx}
\alias{assay_ctx}
\title{plyxp contexts}
\usage{
cols(...)

rows(...)

col_ctx(x, asis = FALSE)

row_ctx(x, asis = FALSE)

assay_ctx(x, asis = FALSE)
}
\arguments{
\item{x, ...}{expressions to evaluate within its associated context}

\item{asis}{asis = FALSE (the default) will indicate using active bindings
that attempt to coerce the underlying data into a format that is appropriate
for the current context. Indicating TRUE will instead bind the underlying data
as is.}
}
\value{
function called for its side-effects
}
\description{
Contextual user-facing helper function for dplyr verbs with SummarizedExperiment
objects. These functions are intended to be used as the top level call to
any dplyr verbs \code{...} argument, similar to that of \code{across()}/\code{if_any()}/\code{if_all()}.

Specifies that the following expressions should be evaluated within the
colData context.

Specifies that the following expressions should be evaluated within the
rowData context.

Specify a single expression to evaluate in another context

Specify a single expression to evaluate in another context

Specify a single expression to evaluate in another context
}
\examples{

# cols
mutate(se_simple,
  cols(is_drug = condition == "drug"),
  # bind a different context
  effect = col_ctx(counts + (is_drug * rbinom(n(), 20, .3)))
)

}
