% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-rangewise-setops.R
\name{intersect_ranges}
\alias{intersect_ranges}
\alias{intersect_ranges_directed}
\alias{union_ranges}
\alias{union_ranges_directed}
\alias{setdiff_ranges}
\alias{setdiff_ranges_directed}
\alias{complement_ranges}
\alias{complement_ranges_directed}
\title{Vector-wise Range set-operations}
\usage{
intersect_ranges(x, y)

intersect_ranges_directed(x, y)

union_ranges(x, y)

union_ranges_directed(x, y)

setdiff_ranges(x, y)

setdiff_ranges_directed(x, y)

complement_ranges(x)

complement_ranges_directed(x)
}
\arguments{
\item{x, y}{Two Ranges objects to compare.}
}
\value{
A Ranges object
}
\description{
Vector-wise Range set-operations
}
\details{
These are usual set-operations that act on the sets of the
ranges represented in x and y. By default these operations will ignore
any strand information. The directed versions of these functions will
take into account strand for GRanges objects.
}
\examples{
gr1 <- data.frame(seqnames = "chr1",
                  start = c(2,9),
                  end = c(7,9),
                  strand = c("+", "-")) \%>\%
               as_granges()
gr2 <- data.frame(seqnames = "chr1", start = 5, width = 5, strand = "-") \%>\%
         as_granges()

union_ranges(gr1, gr2)
union_ranges_directed(gr1, gr2)

intersect_ranges(gr1, gr2)
intersect_ranges_directed(gr1, gr2)

setdiff_ranges(gr1, gr2)
setdiff_ranges_directed(gr1, gr2)
# taking the complement of a ranges requires annotation information
gr1 <- set_genome_info(gr1, seqlengths = 100)
complement_ranges(gr1)

}
