% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-colwise.R
\name{remove_names}
\alias{remove_names}
\alias{names_to_column}
\alias{id_to_column}
\title{Tools for working with named Ranges}
\usage{
remove_names(.data)

names_to_column(.data, var = "name")

id_to_column(.data, var = "id")
}
\arguments{
\item{.data}{a Ranges object}

\item{var}{Name of column to use for names}
}
\value{
Returns a Ranges object with empty names
}
\description{
Tools for working with named Ranges
}
\details{
The function \code{names_to_column()} and \code{id_to_column()} always places
\code{var} as the first column in \code{mcols(.data)}, shifting all other columns
to the left. The \code{id_to_column()} creates a column with sequential row
identifiers starting at 1, it will also remove any existing names.
}
\examples{
ir <- IRanges::IRanges(start = 1:3, width = 4, names = c("a", "b", "c"))
remove_names(ir)
ir_noname <- names_to_column(ir)
ir_noname
ir_with_id <- id_to_column(ir)
ir_with_id
}
