% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{dplyr-filter}
\alias{dplyr-filter}
\alias{filter.GInteractions}
\title{Subset a GInteractions with tidyverse-like \code{filter}}
\usage{
\method{filter}{GInteractions}(.data, ...)
}
\arguments{
\item{.data}{a GInteractions object}

\item{...}{\if{html}{\out{<data-masking>}} Expressions that return a logical value,
and are defined in terms of the variables in .data. If multiple
expressions are included, they are combined with the & operator.
Only rows for which all conditions evaluate to TRUE are kept.}
}
\value{
a GInteractions object.
}
\description{
Subset a GInteractions with tidyverse-like \code{filter}
}
\examples{
gi <- read.table(text = "
chr1 1 10 chr1 1 10
chr1 2 10 chr2 1 10
chr3 3 10 chr3 1 10
chr4 4 10 chr4 1 10
chr5 5 10 chr5 1 10",
col.names = c(
    "seqnames1", "start1", "end1", 
    "seqnames2", "start2", "end2")
) |> 
  as_ginteractions() |> 
  mutate(cis = seqnames1 == seqnames2, score = runif(5)*100, gc = runif(5))
gi

####################################################################
# 1. Filter metadata columns from GInteractions by condition
####################################################################

gi |> filter(gc > 0.1)
gi |> filter(gc > 0.1, score > 50)
gi |> filter(cis)

####################################################################
# 2. On-the-fly calculations
####################################################################

gi
gi |> filter(start1 >= start2 + 3)
gi |> filter(score * gc > score * 0.5)

}
