% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair-granges.R
\name{pair_granges}
\alias{pair_granges}
\title{Pairwise combination of a GRanges object}
\usage{
pair_granges(x)
}
\arguments{
\item{x}{A GRanges object}
}
\value{
A GInteractions object
}
\description{
Create a GInteractions object from a GRanges object,
containing all possible entry pairs
}
\examples{
gr <- read.table(text = "
chr1 100 200
chr1 5000 5100
chr1 1000 5000
chr2 3000 3800",
col.names = c(
  "seqnames", "start", "end" 
)) |> plyranges::as_granges()

pair_granges(gr)
}
