% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ginteractions-getters.R
\name{anchors1}
\alias{anchors1}
\alias{anchors2}
\alias{seqnames1}
\alias{seqnames2}
\alias{start1}
\alias{start2}
\alias{end1}
\alias{end2}
\alias{width1}
\alias{width2}
\alias{strand1}
\alias{strand2}
\alias{ranges1}
\alias{ranges2}
\alias{ginteractions-getters}
\alias{$,GInteractions-method}
\alias{anchors1,GInteractions-method}
\alias{anchors2,GInteractions-method}
\alias{seqnames1,GInteractions-method}
\alias{seqnames2,GInteractions-method}
\alias{start1,GInteractions-method}
\alias{start2,GInteractions-method}
\alias{end1,GInteractions-method}
\alias{end2,GInteractions-method}
\alias{width1,GInteractions-method}
\alias{width2,GInteractions-method}
\alias{strand1,GInteractions-method}
\alias{strand2,GInteractions-method}
\alias{ranges1,GInteractions-method}
\alias{ranges2,GInteractions-method}
\title{Enhanced GInteractions getters}
\usage{
anchors1(x)

anchors2(x)

seqnames1(x)

seqnames2(x)

start1(x)

start2(x)

end1(x)

end2(x)

width1(x)

width2(x)

strand1(x)

strand2(x)

ranges1(x)

ranges2(x)

\S4method{$}{GInteractions}(x, name)

\S4method{anchors1}{GInteractions}(x)

\S4method{anchors2}{GInteractions}(x)

\S4method{seqnames1}{GInteractions}(x)

\S4method{seqnames2}{GInteractions}(x)

\S4method{start1}{GInteractions}(x)

\S4method{start2}{GInteractions}(x)

\S4method{end1}{GInteractions}(x)

\S4method{end2}{GInteractions}(x)

\S4method{width1}{GInteractions}(x)

\S4method{width2}{GInteractions}(x)

\S4method{strand1}{GInteractions}(x)

\S4method{strand2}{GInteractions}(x)

\S4method{ranges1}{GInteractions}(x)

\S4method{ranges2}{GInteractions}(x)
}
\arguments{
\item{x}{a GInteractions object}

\item{name}{The pattern or name of a column stored in
the GInteractions metadata (mcols).}
}
\value{
One of the core GInteractions fields (e.g. seqnames1, start1, ...)
or one of the metadata columns when using \code{$}.
Note that auto-completion works with \code{$}.
}
\description{
Enhanced GInteractions getters
}
\examples{
gi <- data.frame(
  seqnames1 = 'chr1', start1 = 1, end1 = 10, 
  seqnames2 = 'chr1', start2 = 2, end2 = 20
) |> as_ginteractions() |> mutate(type = 'cis')
anchors1(gi)
anchors2(gi)
seqnames1(gi)
seqnames2(gi)
start1(gi)
start2(gi)
end1(gi)
end2(gi)
width1(gi)
width2(gi)
ranges1(gi)
ranges2(gi)
strand1(gi)
strand2(gi)
gi$type
}
