% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCool.R
\name{readCoolNorms}
\alias{readCoolNorms}
\title{Read normalizations included in .(m)cool files}
\usage{
readCoolNorms(file, resolution = NULL)
}
\arguments{
\item{file}{A character value specifying the path to the .(m)cool file}

\item{resolution}{optional, specify which resolution(s) to read 
normalization types from. Default is all resolutions in `file`.}
}
\value{
A vector or list of vectors of available normalizations
}
\description{
Read normalizations included in .(m)cool files
}
\details{
The "BALANCE" normalization refers to applying the pre-calculated matrix 
balancing weights in the `weight` dataset of `file`, typically present
in files created using cooler. VC is vanilla coverage, 
VC_SQRT is square root of vanilla coverage, 
and KR is Knight-Ruiz normalization.

Please note that if using a file from HiC-Pro, ICE normalizations will come
from files stored in a separate folder, and thus will not contain any 
normalizations explicitly called "ICE" or "BALANCE" since values are 
included already normalized. This normalization can be specified as "NONE".
}
\author{
Sarah Parker, Nicole Kramer
}
