% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBigwig.R
\name{readBigwig}
\alias{readBigwig}
\title{Read a bigWig file and return it as a data frame}
\usage{
readBigwig(
    file,
    chrom = NULL,
    chromstart = 1,
    chromend = .Machine$integer.max,
    strand = "*",
    params = NULL
)
}
\arguments{
\item{file}{A character value specifying the path to the bigwig file.}

\item{chrom}{Chromosome of data as a string, if data for a specific
chromosome is desired.}

\item{chromstart}{Integer start position on chromosome.}

\item{chromend}{Integer end position on chromosome.}

\item{strand}{A character value specifying strand.
Default value is \code{strand = "*"}. Options are:
\itemize{
\item{\code{"+"}: }{Plus strand.}
\item{\code{"-"}: }{Minus strand.}
\item{\code{"*"}: }{Plus and minus strands.}
}}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}
}
\value{
Returns a 6-column dataframe of bigwig information.
}
\description{
Read a bigWig file and return it as a data frame
}
\details{
This function does not work on Windows.
}
\examples{
if (.Platform$OS.type != "windows"){
    bwFile <- system.file("extdata/test.bw", package="plotgardenerData")

    ## Read in entire file
    bwData <- readBigwig(file = bwFile)

    ## Read in specified region
    bwRegion <- readBigwig(file = bwFile,
                            chrom = "chr2",
                            chromstart = 1,
                            chromend = 1500)
}

}
\seealso{
\link[rtracklayer]{import.bw}
}
