% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSignal.R
\name{plotSignal}
\alias{plotSignal}
\title{Plot any kind of signal track data for a single chromosome}
\usage{
plotSignal(
    data,
    binSize = NA,
    binCap = TRUE,
    negData = FALSE,
    chrom,
    chromstart = NULL,
    chromend = NULL,
    assembly = "hg38",
    linecolor = "#37a7db",
    fill = NA,
    ymax = 1,
    range = NULL,
    scale = FALSE,
    label = NULL,
    bg = NA,
    baseline = TRUE,
    baseline.color = "grey",
    baseline.lwd = 1,
    orientation = "h",
    x = NULL,
    y = NULL,
    width = NULL,
    height = NULL,
    just = c("left", "top"),
    default.units = "inches",
    draw = TRUE,
    params = NULL,
    ...
)
}
\arguments{
\item{data}{Data to be plotted as a character value specifying a
bigwig file path, a dataframe in BED format, or a
\link[GenomicRanges]{GRanges} object with metadata column \code{score}.
Either one \code{data} argument or a list of two can be provided, where
the second \code{data} will be plotted below the x-axis if positive.
The second \code{data} can also be negative data.}

\item{binSize}{A numeric specifying the length of each data
bin in basepairs. Default value is \code{binSize = NA}.}

\item{binCap}{A logical value indicating whether the function will
limit the number of data bins to 8,000.
Default value is \code{binCap = TRUE}.}

\item{negData}{A logical value indicating whether the provided data has 
negative scores. Default value is \code{negData = FALSE}.}

\item{chrom}{Chromosome of region to be plotted, as a string.}

\item{chromstart}{Integer start position on chromosome to be plotted.}

\item{chromend}{Integer end position on chromosome to be plotted.}

\item{assembly}{Default genome assembly as a string or a
\link[plotgardener]{assembly} object.
Default value is \code{assembly = "hg38"}.}

\item{linecolor}{A character value or vector of length 2 specifying the
line color(s) outlining the signal track(s).
Default value is \code{linecolor = "#37a7db"}.}

\item{fill}{A character value or vector of length 2 specifying
the fill color(s) of the signal track(s). Default value is \code{fill = NA}.}

\item{ymax}{A numeric specifying the fraction of the max y-value
to set as the height of the plot. Default value is \code{ymax = 1}.}

\item{range}{A numeric vector of length 2 specifying the y-range
of data to plot (c(min, max)).}

\item{scale}{A logical value indicating whether to include a data
scale label in the top left corner of the plot.
Default value is \code{scale = FALSE}.}

\item{label}{An optional character value to conveniently add a text label
to the plot. If \code{scale = TRUE}, the label will be draw in the top right
of the plot. Otherwise, the label will be drawn in the top left of the plot.
For more customizable labels, use \link[plotgardener]{plotText}.
Default value is \code{label = NULL}.}

\item{bg}{Character value indicating background color.
Default value is \code{bg = NA}.}

\item{baseline}{Logical value indicating whether to include a
baseline along the x-axis. Default value is \code{baseline = TRUE}.}

\item{baseline.color}{Baseline color.
Default value is \code{baseline.color = "grey"}.}

\item{baseline.lwd}{Baseline line width.
Default value is \code{baseline.lwd = 1}.}

\item{orientation}{A string specifying signal track orientation.
Default value is \code{orientation = "h"}. Options are:
\itemize{
\item{\code{"v"}: }{Vertical signal track orientation.}
\item{\code{"h"}: }{Horizontal signal track orientation.}
}}

\item{x}{A numeric or unit object specifying signal plot x-location.}

\item{y}{A numeric, unit object, or character containing a "b"
combined with a numeric value specifying signal plot y-location.
The character value will
place the signal plot y relative to the bottom of the most recently
plotted plot according to the units of the plotgardener page.}

\item{width}{A numeric or unit object specifying signal plot width.}

\item{height}{A numeric or unit object specifying signal plot height.}

\item{just}{Justification of signal plot relative to its (x, y) location.
If there are two values, the first value specifies horizontal justification
and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use if
\code{x}, \code{y}, \code{width}, or \code{height} are only given as
numerics. Default value is \code{default.units = "inches"}.}

\item{draw}{A logical value indicating whether graphics output should be
produced. Default value \code{draw = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object containing
relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{signal} object containing relevant
genomic region, placement, and \link[grid]{grob} information.
}
\description{
Plot any kind of signal track data for a single chromosome
}
\details{
#A signal track can be placed on a plotgardener coordinate page
by providing plot placement parameters:
\preformatted{
plotSignal(data, chrom,
            chromstart = NULL, chromend = NULL,
            x, y, width, height, just = c("left", "top"),
            default.units = "inches")
}
This function can also be used to quickly plot an unannotated
signal track by ignoring plot placement parameters:
\preformatted{
plotSignal(data, chrom,
            chromstart = NULL, chromend = NULL)
}
}
\examples{
## Load signal data
library(plotgardenerData)
data("IMR90_ChIP_H3K27ac_signal")
data("GM12878_ChIP_H3K27ac_signal")

## Create a page
pageCreate(width = 7.5, height = 2.1, default.units = "inches")

## Define region
region <- pgParams(
    chrom = "chr21",
    chromstart = 28000000, chromend = 30300000,
    assembly = "hg19",
    range = c(0, 45)
)

## Plot and place signal plots
signal1 <- plotSignal(
    data = IMR90_ChIP_H3K27ac_signal, params = region,
    x = 0.5, y = 0.25, width = 6.5, height = 0.65,
    just = c("left", "top"), default.units = "inches"
)

signal2 <- plotSignal(
    data = GM12878_ChIP_H3K27ac_signal, params = region,
    linecolor = "#7ecdbb",
    x = 0.5, y = 1, width = 6.5, height = 0.65,
    just = c("left", "top"), default.units = "inches"
)

## Plot genome label
plotGenomeLabel(
    chrom = "chr21",
    chromstart = 28000000, chromend = 30300000,
    assembly = "hg19",
    x = 0.5, y = 1.68, length = 6.5,
    default.units = "inches"
)

## Add text labels
plotText(
    label = "IMR90", fonsize = 10, fontcolor = "#37a7db",
    x = 0.5, y = 0.25, just = c("left", "top"),
    default.units = "inches"
)
plotText(
    label = "GM12878", fonsize = 10, fontcolor = "#7ecdbb",
    x = 0.5, y = 1, just = c("left", "top"),
    default.units = "inches"
)

## Hide page guides
pageGuideHide()
}
