% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRanges.R
\name{plotRanges}
\alias{plotRanges}
\title{Plot genomic range elements in a pileup or collapsed format}
\usage{
plotRanges(
    data,
    chrom,
    chromstart = NULL,
    chromend = NULL,
    assembly = "hg38",
    fill = "#7ecdbb",
    linecolor = NA,
    order = "width",
    collapse = FALSE,
    boxHeight = unit(2, "mm"),
    spaceWidth = 0.02,
    spaceHeight = 0.3,
    limitLabel = TRUE,
    strandSplit = FALSE,
    bg = NA,
    baseline = FALSE,
    baseline.color = "grey",
    baseline.lwd = 1,
    x = NULL,
    y = NULL,
    width = NULL,
    height = NULL,
    just = c("left", "top"),
    default.units = "inches",
    draw = TRUE,
    params = NULL,
    ...
)
}
\arguments{
\item{data}{Data to be plotted; as a character value specifying
a BED file path, a data frame in BED format, a character value
specifying a .bam file path where a bam index file (.bam.bai)
is in the same directory, or a \link[GenomicRanges]{GRanges} object.}

\item{chrom}{Chromosome of region to be plotted, as a string.}

\item{chromstart}{Integer start position on chromosome to be plotted.}

\item{chromend}{Integer end position on chromosome to be plotted.}

\item{assembly}{Default genome assembly as a string or a
\link[plotgardener]{assembly} object.
Default value is \code{assembly = "hg38"}.}

\item{fill}{A single character value, a vector, or a 
\link[plotgardener]{colorby} object specifying fill colors of range elements.
Default value is \code{fill = "#7ecdbb"}.}

\item{linecolor}{A single character value, a vector, or a
\link[plotgardener]{colorby} object specifying the color of the lines
outlining range elements. Default value is \code{linecolor = NA}.
Special options include:
\itemize{
\item{\code{NA}: }{No line color.}
\item{\code{"fill"}: }{Same color as \code{fill}.}
} .}

\item{order}{A character value specifying how to order pileup data
before assigning rows. Default value is \code{order = "width"}. Options 
include:
\itemize{
\item{\code{"width"}: }{Ordered by decreasing width of elements.}
\item{\code{"random"}: }{Ordered randomly in each function call.}
} .}

\item{collapse}{A logical value indicating whether to collapse
range elements into a single row, or into
two rows if \code{strandSplit = TRUE}.
If \code{collapse = TRUE}, \code{boxHeight} will be ignored and elements
will be the height of the entire plot if \code{strandSplit = FALSE} or
be the height of half of the entire plot if \code{strandSplit = TRUE}.
Default value is \code{collapse = FALSE}.}

\item{boxHeight}{A numeric or unit object specifying height of range element
boxes. Default value is \code{boxHeight = unit(2, "mm")}.}

\item{spaceWidth}{A numeric value specifying the width of minimum spacing
between range element boxes, as a fraction of the plot's genomic range.
Default value is \code{spaceWidth = 0.02}.}

\item{spaceHeight}{A numeric value specifying the height of spacing between
range element boxes on different rows, as a fraction of boxHeight.
Default value is \code{spaceHeight = 0.3}.}

\item{limitLabel}{A logical value indicating whether to draw a "+"
when not all elements can be plotted in the plotting space. Default 
value is \code{limitLabel = TRUE}.}

\item{strandSplit}{A logical value indicating whether plus and
minus-stranded elements should be separated. Elements can only be
split by strand if a \code{strand} column is found in \code{data}.
Default value is \code{strandSplit = FALSE}.}

\item{bg}{Character value indicating background color.
Default value is \code{bg = NA}.}

\item{baseline}{Logical value indicating whether to include a
baseline along the x-axis. Default value is \code{baseline = FALSE}.}

\item{baseline.color}{Baseline color.
Default value is \code{baseline.color = "grey"}.}

\item{baseline.lwd}{Baseline line width.
Default value is \code{baseline.lwd = 1}.}

\item{x}{A numeric or unit object specifying ranges plot x-location.}

\item{y}{A numeric, unit object, or character containing a "b"
combined with a numeric value specifying ranges plot y-location.
The character value will
place the ranges plot y relative to the bottom of the most recently
plotted plot according to the units of the plotgardener page.}

\item{width}{A numeric or unit object specifying ranges plot width.}

\item{height}{A numeric or unit object specifying ranges plot height.}

\item{just}{Justification of ranges plot relative to its (x, y) location.
If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use
if \code{x}, \code{y}, \code{width}, or \code{height} are only given
as numerics. Default value is \code{default.units = "inches"}.}

\item{draw}{A logical value indicating whether graphics output should
be produced. Default value \code{draw = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{ranges} object containing relevant
genomic region, coloring data, placement, and \link[grid]{grob} information.
}
\description{
Plot genomic range elements in a pileup or collapsed format
}
\details{
A ranges plot can be placed on a plotgardener coordinate page by providing
plot placement parameters:
\preformatted{
plotRanges(data, chrom,
            chromstart = NULL, chromend = NULL,
            x, y, width, height, just = c("left", "top"),
            default.units = "inches")
}
This function can also be used to quickly plot an unannotated BED plot
by ignoring plot placement parameters:
\preformatted{
plotRanges(data, chrom,
            chromstart = NULL, chromend = NULL)
}
}
\examples{
## Load ranges data in BED format
library(plotgardenerData)
data("IMR90_ChIP_CTCF_reads")

## Create page
pageCreate(width = 7.5, height = 5, default.units = "inches")

## Plot and place a pileup ranges plot
pileupPlot <- plotRanges(
    data = IMR90_ChIP_CTCF_reads, chrom = "chr21",
    chromstart = 29073000, chromend = 29074000,
    assembly = "hg19",
    order = "random",
    fill = colorby("strand", palette = 
                colorRampPalette(c("#7ecdbb", "#37a7db"))),
    strandSplit = TRUE, 
    x = 0.5, y = 0.25, width = 6.5, height = 4.25,
    just = c("left", "top"), default.units = "inches"
)

## Annotate genome label
annoGenomeLabel(
    plot = pileupPlot, x = 0.5, y = 4.5,
    just = c("left", "top")
)

## Add text labels
plotText(
    label = "+ strand", fontcolor = "#37a7db", fontsize = 12,
    x = 0.5, y = 1.25, just = "left"
)
plotText(
    label = "- strand", fontcolor = "#7ecdbb", fontsize = 12,
    x = 0.5, y = 3.5, just = "left"
)

## Hide page guides
pageGuideHide()
}
