% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIdeogram.R
\name{plotIdeogram}
\alias{plotIdeogram}
\title{Plot a chromosome ideogram with or without cytobands}
\usage{
plotIdeogram(
    chrom,
    assembly = "hg38",
    data = NULL,
    orientation = "h",
    flip = FALSE,
    showBands = TRUE,
    fill = NULL,
    x = NULL,
    y = NULL,
    width = NULL,
    height = NULL,
    just = c("left", "top"),
    default.units = "inches",
    draw = TRUE,
    params = NULL
)
}
\arguments{
\item{chrom}{Chromosome to be plotted, as a string.}

\item{assembly}{Default genome assembly as a string or a
\link[plotgardener]{assembly} object.
Default value is \code{assembly = "hg38"}.}

\item{data}{Custom cytoband data, as a dataframe with the following
columns: "seqnames", "start", "end", "width", "strand",
"name", "gieStain".}

\item{orientation}{Character value indicating the orientation
of the ideogram. Default value is \code{orientation = "h"}.
Options are:
\itemize{
\item{\code{"v"}: }{Vertical ideogram orientation.}
\item{\code{"h"}: }{Horizontal ideogram orientation.}
}}

\item{flip}{Logical value indicating whether to reverse the start and end
positions of the ideogram. If \code{flip = FALSE} (default), the ideogram
starts at the top/left and ends at the bottom/right. If \code{flip = TRUE},
the start and end positions are reversed, meaning the ideogram starts at the
bottom/right and ends at the top/left.}

\item{showBands}{Logical value indicating whether to draw
colored cytobands within ideogram.
Default value is \code{showBands = TRUE}.}

\item{fill}{(optional) A vector specifying alternate colors for cytoband
stains. To change specific gieStain values (i.e. gneg, gpos, etc.) to
specific colors, this vector can be named. This vector must have the same
number of colors as there are gieStain values for each genome assembly.}

\item{x}{A numeric or unit object specifying ideogram x-location.}

\item{y}{A numeric, unit object, or character containing a "b"
combined with a numeric value specifying ideogram y-location.
The character value will
place the ideogram y relative to the bottom of the most recently
plotted plot according to the units of the plotgardener page.}

\item{width}{A numeric or unit object specifying ideogram width.}

\item{height}{A numeric or unit object specifying ideogram height.}

\item{just}{Justification of ideogram relative to its (x, y) location.
If there are two values, the first value specifies horizontal justification
and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use if
\code{x}, \code{y}, \code{width}, or \code{height} are only given as
numerics. Default value is \code{default.units = "inches"}.}

\item{draw}{A logical value indicating whether graphics output should be
produced. Default value is \code{draw = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object containing
relevant function parameters.}
}
\value{
Returns a \code{ideogram} object containing relevant
genomic region, placement, and \link[grid]{grob} information.
}
\description{
Plot a chromosome ideogram with or without cytobands
}
\details{
An ideogram can be placed on a plotgardener coordinate page by
providing plot placement parameters:
\preformatted{
plotIdeogram(chrom,
                x, y, width, height, just = c("left", "top"),
                default.units = "inches")
}
This function can also be used to quickly plot an unannotated ideogram
by ignoring plot placement parameters:
\preformatted{
plotIdeogram(chrom)
}
If no data is provided, Giemsa stain band data will first try to
fetch UCSC with AnnotationHub. The results are cached for faster access,
but these cached items can be deleted. If no internet connection is
available and AnnotationHub has not previously cached the data, custom
Giemsa stain band data can be loaded with the `data` parameter.
}
\examples{
## Load Giemsa stain band information and genomic
## annotation data for hg19 genome assembly
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(AnnotationHub)

## Create page
pageCreate(width = 4.5, height = 1, default.units = "inches")

## Plot and place ideogram
ideogramPlot <- plotIdeogram(
    chrom = "chr2", assembly = "hg19",
    x = 0.25, y = 0.25, width = 4, height = 0.3,
    just = c("left", "top"),
    default.units = "inches"
)

## Plot text
plotText(
    label = "Chromosome 2", fontcolor = "dark grey",
    x = 4.25, y = 0.65, just = "right"
)

## Hide page guides
pageGuideHide()
}
\seealso{
\link[AnnotationHub]{AnnotationHub}
}
