% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pageGuideShow.R
\name{pageGuideShow}
\alias{pageGuideShow}
\title{Reshow guides drawn with \code{pageCreate},
\code{pageGuideHorizontal}, and \code{pageGuideVertical}}
\usage{
pageGuideShow()
}
\value{
None.
}
\description{
Reshow guides drawn with \code{pageCreate},
\code{pageGuideHorizontal}, and \code{pageGuideVertical}
}
\examples{
## Load Hi-C data
library(plotgardenerData)
data("IMR90_HiC_10kb")

## Create a page
pageCreate(width = 3, height = 3, default.units = "inches")

## Add a page guide
pageGuideHorizontal(y = 0.5, default.units = "inches")

## Plot and place Hi-C plot
hicPlot <- plotHicSquare(
    data = IMR90_HiC_10kb, resolution = 10000,
    zrange = c(0, 70),
    chrom = "chr21",
    chromstart = 28000000, chromend = 30300000,
    x = 0.5, y = 0.5, width = 2, height = 2,
    just = c("left", "top"),
    default.units = "inches"
)

## Hide page guides
pageGuideHide()

## Re-show page guides
pageGuideShow()

## Annotate genome label
annoGenomeLabel(
    plot = hicPlot, scale = "Mb", axis = "x",
    x = 0.5, y = 2.53, just = c("left", "top")
)
}
\seealso{
\link[plotgardener]{pageCreate},
\link[plotgardener]{pageGuideHorizontal},
\link[plotgardener]{pageGuideVertical}
}
