% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pageGuideHorizontal.R
\name{pageGuideHorizontal}
\alias{pageGuideHorizontal}
\title{Draw a horizontal guideline at a specified y-coordinate
on a plotgardener page}
\usage{
pageGuideHorizontal(
    y,
    default.units = "inches",
    linecolor = "grey55",
    params = NULL,
    ...
)
}
\arguments{
\item{y}{A numeric or unit object specifying y-coordinate of guide.}

\item{default.units}{A string indicating the default units to use
if \code{y} is only given as a numeric.
Default value is \code{default.units = "inches"}.}

\item{linecolor}{Character value indicating color of guideline.
Default value is \code{linecolor = "grey55"}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
None.
}
\description{
Draw a horizontal guideline at a specified y-coordinate
on a plotgardener page
}
\examples{
## Create a page
pageCreate(width = 6, height = 5, default.units = "inches")

## Add red horizontal guideline at y = 2.5 inches
pageGuideHorizontal(y = 2.5, linecolor = "red")
}
