% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assembly.R
\name{assembly}
\alias{assembly}
\title{Make a \code{assembly} object for alternate TxDb, OrgDb,and BSgenome
genomic annotation packages}
\usage{
assembly(
    Genome,
    TxDb,
    OrgDb,
    gene.id.column = "ENTREZID",
    display.column = "SYMBOL",
    BSgenome = NULL
)
}
\arguments{
\item{Genome}{String indicating the name of the genome assembly.}

\item{TxDb}{String of existing TxDb package name or a TxDb object.}

\item{OrgDb}{String of the desired OrgDb package name.}

\item{gene.id.column}{String of the TxDb column name that refers to
the given TxDb gene IDs.
Default value is \code{gene.id.column = "ENTREZID"}.}

\item{display.column}{String of the OrgDb column name that refers to
the type of gene symbol to be displayed in plots.
Default value is \code{display.column = "SYMBOL"}.}

\item{BSgenome}{String of the desired BSgenome package name.}
}
\value{
Returns a \code{assembly} object containing all input parameters.
}
\description{
Make a \code{assembly} object for alternate TxDb, OrgDb,and BSgenome
genomic annotation packages
}
\examples{
## Create a custom `assembly` object for hg38/GRCh38 packages
newAssembly <- assembly(
    Genome = "hg38_GRCh38",
    TxDb = "TxDb.Hsapiens.UCSC.hg38.knownGene",
    OrgDb = "org.Hs.eg.db",
    BSgenome = "BSgenome.Hsapiens.NCBI.GRCh38"
)
}
\seealso{
\link[GenomicFeatures]{TxDb}, \link[AnnotationDbi]{OrgDb-class},
\link[BSgenome]{BSgenome}
}
