% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_sampler.R
\name{wbc_somatic}
\alias{wbc_somatic}
\title{Estimate the marginal likelihood of observing somatic mutations
from CTCs present in buffy coat
p(y_w | theta_w, n_w, model_S) x p(theta_w| Model_S)
theta_w | model_S  ~ beta(1, 999)  ## sequencing error or CTC}
\usage{
wbc_somatic(dat, params)
}
\arguments{
\item{dat}{tibble containing vectors `y`and `n`; `y` and `n` should be named}

\item{params}{a list with named elements that must include the following:
`a`: prior expectation for number of somatic variants
observed in the WBC sequencing data (either by error or from a CTC)
`b`: prior expectation for number of WBCs not containing the variant}
}
\value{
generate importance samples for wbc somatic model
}
\description{
Estimate the marginal likelihood of observing somatic mutations
from CTCs present in buffy coat
p(y_w | theta_w, n_w, model_S) x p(theta_w| Model_S)
theta_w | model_S  ~ beta(1, 999)  ## sequencing error or CTC
}
\examples{
param.list <- list(ctc=list(a=1, b=9999),
                   ctdna=list(a=1, b=9),
                   chip=list(a=1, b=9),
                   montecarlo.samples=50e3,
                   prior.weight=0.1)
dat <- data.frame(y=c(4, 1),
              n=c(1000, 1000),
              analyte=c("plasma", "buffy coat"),
              mutation="mutA",
              sample_id="id1")
wbc_somatic(dat, param.list)
}
