% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_mixOmics.R
\name{predict}
\alias{predict}
\alias{predict.mixo_pls}
\alias{predict.mixo_spls}
\title{predict mixxo from}
\usage{
\method{predict}{mixo_pls}(
  object,
  newdata,
  study.test,
  dist = c("all", "max.dist", "centroids.dist", "mahalanobis.dist"),
  multilevel = NULL,
  ...
)

\method{predict}{mixo_spls}(
  object,
  newdata,
  study.test,
  dist = c("all", "max.dist", "centroids.dist", "mahalanobis.dist"),
  multilevel = NULL,
  ...
)
}
\arguments{
\item{object}{object of class inheriting from
\code{"(mint).(block).(s)pls(da)"}.}

\item{newdata}{data matrix in which to look for for explanatory variables to
be used for prediction. Please note that this method does not perform
multilevel decomposition or log ratio transformations, which need to be
processed beforehand.}

\item{study.test}{For MINT objects, grouping factor indicating which samples
of \code{newdata} are from the same study. Overlap with \code{object$study}
are allowed.}

\item{dist}{distance to be applied for discriminant methods to predict the
class of new data, should be a subset of \code{"centroids.dist"},
\code{"mahalanobis.dist"} or \code{"max.dist"} (see Details). Defaults to
\code{"all"}.}

\item{multilevel}{Design matrix for multilevel analysis (for repeated
measurements). A numeric matrix or data frame. For a one level factor
decomposition, the input is a vector indicating the repeated measures on
each individual, i.e. the individuals ID. For a two level decomposition with
splsda models, the two factors are included in Y. Finally for a two level
decomposition with spls models, 2nd AND 3rd columns in design indicate those
factors (see example in \code{?splsda} and \code{?spls}).}

\item{...}{not used currently.}
}
\value{
\code{predict} produces a list with the following components:
\item{predict}{predicted response values. The dimensions correspond to the
observations, the response variables and the model dimension, respectively.
For a supervised model, it corresponds to the predicted dummy variables.}
\item{variates}{matrix of predicted variates.} \item{B.hat}{matrix of
regression coefficients (without the intercept).}

\item{AveragedPredict}{if more than one block, returns the average predicted
values over the blocks (using the \code{predict} output)}
\item{WeightedPredict}{if more than one block, returns the weighted average
of the predicted values over the blocks (using the \code{predict} and
\code{weights} outputs)}

\item{class}{predicted class of \code{newdata} for each
\eqn{1,...,}\code{ncomp} components.}

\item{MajorityVote}{if more than one block, returns the majority class over
the blocks. NA for a sample means that there is no consensus on the
predicted class for this particular sample over the blocks.}
\item{WeightedVote}{if more than one block, returns the weighted majority
class over the blocks. NA for a sample means that there is no consensus on
the predicted class for this particular sample over the blocks.}
\item{weights}{Returns the weights of each block used for the weighted
predictions, for each nrepeat and each fold}

\item{centroids}{matrix of coordinates for centroids.} \item{dist}{type of
distance requested.} \item{vote}{majority vote result for multi block
analysis (see details above).}
}
\description{
copied from mixOmicsTeam/mixOmics/refs/heads/master/R/predict.R
on 2025 Jan 30. Some components omitted that are not used in planet.
}
\examples{
# example code

}
\references{
Rohart F, Gautier B, Singh A, Lê Cao K-A. mixOmics: an R package for 'omics
feature selection and multiple data integration. PLoS Comput Biol 13(11):
e1005752

Tenenhaus, M. (1998). \emph{La regression PLS: theorie et pratique}. Paris:
Editions Technic.
}
\seealso{
http://www.mixOmics.org for more details.
}
\author{
Florian Rohart, Sébastien Déjean, Ignacio González, Kim-Anh Lê Cao,
Al J Abadi
}
\keyword{multivariate}
\keyword{regression}
